﻿/*****************************************************************************************************
* $$FileName		Clear Topic Status.jsx
*
* $$Description		Sample ExtendScript file to Clear topic status which was added by other sample Script File.
*
* Copyright (c) 2009 Adobe Systems Incorporated. All Rights Reserved.
******************************************************************************************************/

var tagID='TopicStatusID_SOmeUniqueValue';	//this is the unique tag id for the tag so that we can find that out.
main();

function main()
{
	var topicmanager = RoboHelp.project.TopicManager;
	var topic;
	for(var index=1;index<=topicmanager.count;index++)
	{
		topic = topicmanager.item(index);
		ClearTopicStatus(topic);
	}
}


function outputMsg(szString)
{
	RoboHelp.project.outputMessage (szString);
}

function ClearTopicStatus(topic)
{
	var filepath = topic.path;
	var msg = 'Clearing status from topic '+topic.name+'\n';
	outputMsg(msg);
	//this is to get the token manager for the topic specified.
	var tokenmgr = RoboHelp.getTokenManager(filepath);
	var bTokenPresent = false;

	if(typeof(tokenmgr)!='undefined')
	{
		if(tokenmgr.count>0)
		{
			var token = tokenmgr.item(1);
			while(typeof(token)!='undefined')
			{
				//check if it is TAg type and has id as 
				if(token.tokenType == RoboHelp.TokenType.TOKENTAG )
				{
					if(token.tagType == RoboHelp.TagType.TAGPARAGRAPH)
					{
						//this is a p tag and we have to check if it has the ID we have specified
						var id = token.getAttribute('id');
						if(id==tagID)
						{
							//we found the tag we have added earlier so Clear this tag now
							//we need to delete token and next 2 as well
							var nextToken = token.next;
							token.delete();
							token = nextToken.next;
							nextToken.delete();
							token.delete();
							break;
						}
					}
				}
				token = token.next;
			}
		}
	}
		
	tokenmgr.save();
	outputMsg('Updating Done for File ------>>'+filepath+'\n');
}
